/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Geometry;

import BryceMath.Calculations.MathB;
import Data_Structures.Structures.UBA;

public class RectangleD {
    private double x;
    private double y;
    private double w;
    private double h;
    private double x2;
    private double y2;

    public RectangleD(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.x2 = x + w;
        this.y2 = y + h;
    }

    public boolean containsPoint(double px, double py) {
        return px >= this.x && px <= this.x2 && py >= this.y && py <= this.y2;
    }

    public RectangleD intrsection(RectangleD other) {
        double nx = MathB.max(this.x, other.x);
        double ny = MathB.max(this.y, other.y);
        double nx2 = MathB.min(this.x2, other.x2);
        double ny2 = MathB.min(this.y2, other.y2);
        double nw = nx2 - nx;
        double nh = ny2 - ny;
        return new RectangleD(nx, ny, nw, nh);
    }

    public RectangleD union(RectangleD other) {
        double nx = MathB.min(this.x, other.x);
        double ny = MathB.min(this.y, other.y);
        double nx2 = MathB.max(this.x2, other.x2);
        double ny2 = MathB.max(this.y2, other.y2);
        double nw = nx2 - nx;
        double nh = ny2 - ny;
        return new RectangleD(nx, ny, nw, nh);
    }

    public void setX(double x_new) {
        this.x = x_new;
        this.x2 = this.x + this.w;
    }

    public void setY(double y_new) {
        this.y = y_new;
        this.y2 = this.y + this.h;
    }

    public void setW(double w_new) {
        this.w = w_new;
        this.x2 = this.x + this.w;
    }

    public void setH(double h_new) {
        this.h = h_new;
        this.y2 = this.y + this.h;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getW() {
        return this.w;
    }

    public double getH() {
        return this.h;
    }

    public UBA<Double> getBounds() {
        UBA<Double> output = new UBA<Double>(4);
        output.add(this.x);
        output.add(this.y);
        output.add(this.x2);
        output.add(this.x2);
        return output;
    }

    public RectangleD offset(double dx, double dy) {
        return new RectangleD(this.x + dx, this.y + dy, this.w, this.h);
    }

    public String toString() {
        return "Rectangle[ X = " + this.x + ", Y = " + this.y + ", W = " + this.w + ", H = " + this.h + "]";
    }
}

